function remote_init()
	local items={
		{name="Keyboard", input="keyboard"},
		{name="Channel Pressure", input="value", min=0, max=127},
		{name="Mod Wheel", input="value", min=0, max=127},
		{name="Pitch Bend", input="value", min=0, max=16384},
		{name="Expression", input="value", min=0, max=127},
		{name="Breath", input="value", min=0, max=127},
		{name="Damper Pedal", input="button"},

		{name="volume", input="value", min=0, max=127},

		{name="snap1", input="button"},
		{name="snap2", input="button"},
		{name="snap3", input="button"},
		{name="snap4", input="button"},
		{name="snap5", input="button"},
		{name="snap6", input="button"},
		{name="snap7", input="button"},
		{name="snap8", input="button"},
		{name="snap9", input="button"},
		{name="snap10", input="button"},

		{name="cut", input="value", min=0, max=127},
		{name="reso", input="value", min=0, max=127},
		{name="chorus", input="value", min=0, max=127},
		{name="delay", input="value", min=0, max=127},
		{name="lforate", input="value", min=0, max=127},
		{name="lfoamt", input="value", min=0, max=127},

		{name="cut2", input="value", min=0, max=127},
		{name="reso2", input="value", min=0, max=127},
		{name="chorus2", input="value", min=0, max=127},
		{name="delay2", input="value", min=0, max=127},
		{name="lforate2", input="value", min=0, max=127},
		{name="lfoamt2", input="value", min=0, max=127},

		{name="param1", input="value", min=0, max=127},
		{name="param2", input="value", min=0, max=127},
		{name="param3", input="value", min=0, max=127},
		{name="param4", input="value", min=0, max=127},

		{name="param1b", input="value", min=0, max=127},
		{name="param2b", input="value", min=0, max=127},
		{name="param3b", input="value", min=0, max=127},
		{name="param4b", input="value", min=0, max=127},
		
		
		{name="record", input="button"},
		{name="stop", input="button"},
		{name="play", input="button"},
		{name="loop", input="button"},
		{name="rew", input="button"},
		{name="fwd", input="button"},
		
		
		{name="atk1", input="value", min=0, max=127},
		{name="dec1", input="value", min=0, max=127},
		{name="sus1", input="value", min=0, max=127},
		{name="rel1", input="value", min=0, max=127},

		{name="atk2", input="value", min=0, max=127},
		{name="dec2", input="value", min=0, max=127},
		{name="sus2", input="value", min=0, max=127},
		{name="rel2", input="value", min=0, max=127},
		{name="fader9a", input="value", min=0, max=127},

		{name="atk3", input="value", min=0, max=127},
		{name="dec3", input="value", min=0, max=127},
		{name="sus3", input="value", min=0, max=127},
		{name="rel3", input="value", min=0, max=127},

		{name="atk4", input="value", min=0, max=127},
		{name="dec4", input="value", min=0, max=127},
		{name="sus4", input="value", min=0, max=127},
		{name="rel4", input="value", min=0, max=127},
		{name="fader9b", input="value", min=0, max=127},	
	
		{name="category", input="delta"},
		{name="preset", input="delta"},
		{name="cat_switch", input="button"},
		{name="pre_switch", input="button"},

	

			}
	remote.define_items(items)

	local inputs={

		{pattern="b0 07 xx", name="volume"},

		{pattern="b0 16 xx", name="snap1", value="1"},
		{pattern="b0 17 xx", name="snap2", value="1"},
		{pattern="b0 18 xx", name="snap3", value="1"},
		{pattern="b0 19 xx", name="snap4", value="1"},
		{pattern="b0 1A xx", name="snap5", value="1"},
		{pattern="b0 1B xx", name="snap6", value="1"},
		{pattern="b0 1C xx", name="snap7", value="1"},
		{pattern="b0 1D xx", name="snap8", value="1"},
		{pattern="b0 1E xx", name="snap9", value="1"},
		{pattern="b0 1F xx", name="snap10", value="1"},

		{pattern="b0 49 xx", name="atk1"},
		{pattern="b0 4B xx", name="dec1"},
		{pattern="b0 4f xx", name="sus1"},
		{pattern="b0 48 xx", name="rel1"},

		{pattern="b0 50 xx", name="atk2"},
		{pattern="b0 51 xx", name="dec2"},
		{pattern="b0 52 xx", name="sus2"},
		{pattern="b0 53 xx", name="rel2"},
		{pattern="b0 55 xx", name="fader9a"},

		{pattern="b0 43 xx", name="atk3"},
		{pattern="b0 44 xx", name="dec3"},
		{pattern="b0 45 xx", name="sus3"},
		{pattern="b0 46 xx", name="rel3"},

		{pattern="b0 57 xx", name="atk4"},
		{pattern="b0 58 xx", name="dec4"},
		{pattern="b0 59 xx", name="sus4"},
		{pattern="b0 5A xx", name="rel4"},
		{pattern="b0 5C xx", name="fader9b"},

		{pattern="b0 4a xx", name="cut"},
		{pattern="b0 47 xx", name="reso"},
		{pattern="b0 4c xx", name="lforate"},
		{pattern="b0 4d xx", name="lfoamt"},
		{pattern="b0 5d xx", name="chorus"},
		{pattern="b0 5b xx", name="delay"},

		{pattern="b0 12 xx", name="param1"},
		{pattern="b0 13 xx", name="param2"},
		{pattern="b0 10 xx", name="param3"},
		{pattern="b0 11 xx", name="param4"},

		{pattern="b0 23 xx", name="cut2"},
		{pattern="b0 24 xx", name="reso2"},
		{pattern="b0 25 xx", name="lforate2"},
		{pattern="b0 26 xx", name="lfoamt2"},
		{pattern="b0 27 xx", name="chorus2"},
		{pattern="b0 2c xx", name="delay2"},

		{pattern="b0 28 xx", name="param1b"},
		{pattern="b0 29 xx", name="param2b"},
		{pattern="b0 2a xx", name="param3b"},
		{pattern="b0 2b xx", name="param4b"},


		{pattern="b0 70 xx", name="category", value="(64 - x) * -1"},	
		{pattern="b0 72 xx", name="preset", value="(64 - x) * -1"},

		{pattern="b0 73 xx", name="pre_switch", value="1"},
		{pattern="b0 71 xx", name="cat_switch", value="1"},

		{pattern="F0 7F 7F 06 06 F7", name="record", value="1"},
		{pattern="F0 7F 7F 06 01 F7", name="stop", value="1"},
		{pattern="F0 7F 7F 06 02 F7", name="play", value="1"},
		{pattern="F0 7F 7F 06 05 F7", name="rew", value="1"},
		{pattern="F0 7F 7F 06 04 F7", name="fwd", value="1"},
		{pattern="b0 37 xx", name="loop", value="1"},

		{pattern="e? xx yy", name="Pitch Bend", value="y*128 + x"},
		{pattern="b0 01 xx", name="Mod Wheel"},
		{pattern="b0 0b xx", name="Expression"},
		{pattern="b0 02 xx", name="Breath"},
		{pattern="d0 xx", name="Channel Pressure"},
		{pattern="b0 40 xx", name="Damper Pedal", value="1"},

		{pattern="8z xx yy", name="Keyboard", value="0", note="x", velocity="64"},	
		{pattern="9z xx 00", name="Keyboard", value="0", note="x", velocity="64"},
		{pattern="<100x>0 yy zz", name="Keyboard"},

	
	}
	remote.define_auto_inputs(inputs)
end


function remote_probe()

	local controlRequest="F0 7E 7F 06 01 F7"

	local controlResponse="F0 7E 00 06 02 00 20 6B 02 00 05 00 ?? ?? ?? ?? F7"
return {
		request=controlRequest,
		response=controlResponse
	}
end

